﻿using System;
using System.Data;  //DEBUG(ETM) This may not be needed
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Expressions;
using System.Web;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.BusinessManager.Utilities;
using VeteransAffairs.Registries.BusinessManager.TBI;
using VeteransAffairs.Registries.BusinessManager.MDWS; // Add 29-Oct-2010 per JH
using System.Text;
using System.Runtime.InteropServices;
using Telerik.Web.UI;
using BusinessHelper = VeteransAffairs.Registries.Business.Utilities.Helpers;

public partial class TBI_PhysicalFunctionwMobilityAid : BaseTBIInstrumentPage //System.Web.UI.Page 
{

    #region Variable Declarations

    private const string FailedFormValuesName = "PhysicalFunctionwMobilityAidFailedFormValues";
    private const string DeferredMessageKeyName = "PhysicalFunctionwMobilityAidDeferredMessageKey";
    private const int _surveyTypeId = 38; // Database Id for PhysicalFunctionwMobilityAid 

    PatientManager patientManager = new PatientManager();
    InstrumentType instrumentType = new InstrumentType();
    SURVEY _survey;   // the root object in the Survey set
    // DataTable prevM2PINotes = new DataTable();
    DataTable prevPhysicalFunctionwMobilityAid = new DataTable();
    List<STD_QUESTION> QuestionList = new List<STD_QUESTION>();
    SURVEY_RESULT _surveyResult; // the object representing the actual data in the Survey
    bool isFollowUp = false;
    bool hasDischarge = false;

    public delegate void MasterPageMenuClickHandler(object sender, MenuEventArgs e);
    public event MasterPageMenuClickHandler MenuClick;
    #endregion

    #region Public Methods
    protected void Menu2_MenuItemClick(object sender, MenuEventArgs e)
    {
        if (MenuClick != null)
        {
            MenuClick(sender, e);
        }
    }
    public TBI_PhysicalFunctionwMobilityAid()
    {
        //Manager Save Notification Event Handler
        patientManager.BOSaveSuccess += manager_BOSaveSuccess;
    }

    #endregion

    #region Protected Methods

    private InstrumentType selectedInstrumentType;

    protected void Page_Init(object sender, EventArgs e)
    {
        selectedInstrumentType = _tbiInstrumentManager.GetInstrumentByID(_surveyTypeId);
        VeteransAffairs.Registries.QuestionChoiceRetriever.Reset(_tbiInstrumentManager, _surveyTypeId);
    }

    protected void Page_Unload(object sender, EventArgs e)
    {
        VeteransAffairs.Registries.QuestionChoiceRetriever.Reset(null, -1);
    }

    bool preventNotification = false;
    protected void Page_PreRenderComplete(object sender, EventArgs e)
    {
        Dictionary<string, string> cache;
        preventNotification = Request.UrlReferrer.ToString().Contains("InstrumentSummaryNote");
        if (preventNotification != true)
        {
            if (!Page.IsPostBack && Helpers.SetupPageFromCache(this, FailedFormValuesName, out cache))
            {
                SaveFailMessage = "Unable to save the survey.\r\n\r\nThere may be network issues preventing you from saving.\r\n\r\nPlease try to submit your changes again.";
                RenderStartUpMessage(false);
            }
            else if (Page.IsPostBack && !preventNotification)
            {
                DeferredMessage = "Save was Successful!";
            }
            else if (DeferredMessage != null)
            {
                SuppressSaveMessage = false;
                SaveSuccessMessage = DeferredMessage;
                RenderStartUpMessage(true);
                DeferredMessage = null;
            }
            if (RadioButtonListQ12.SelectedIndex > -1)
            {
                if (RadioButtonListQ12.SelectedIndex == 1)
                {
                    RadioButtonListQ1.Enabled = false;
                    RadioButtonListQ2.Enabled = false;
                    RadioButtonListQ3.Enabled = false;
                    RequiredFieldValidatorQ1.Enabled = false;
                    RequiredFieldValidatorQ2.Enabled = false;
                    RequiredFieldValidatorQ3.Enabled = false;
                }
                else
                {
                    RadioButtonListQ1.Enabled = true;
                    RadioButtonListQ2.Enabled = true;
                    RadioButtonListQ3.Enabled = true;
                    RequiredFieldValidatorQ1.Enabled = true;
                    RequiredFieldValidatorQ2.Enabled = true;
                    RequiredFieldValidatorQ3.Enabled = true;
                }
            }
        }
        else /*if (DeferredMessage != null)*/
        {
            // SuppressSaveMessage = false;
            SaveSuccessMessage = DeferredMessage;
            //RenderStartUpMessage(true);
            DeferredMessage = null;
            if (Session["NoteTypeMob"] != null)
            {
                rbNoteType.SelectedIndex = Convert.ToInt32(Session["NoteTypeMob"].ToString());
            }
            if (Session["IOCNumberMob"] != null)
            {
                prevNotesList.SelectedIndex = Convert.ToInt32(Session["IOCNumberMob"].ToString());
            }
        }

        if (RadioButtonListQ12.SelectedIndex > -1)
        {
            if (RadioButtonListQ12.SelectedIndex == 1)
            {
                RadioButtonListQ1.Enabled = false;
                RadioButtonListQ2.Enabled = false;
                RadioButtonListQ3.Enabled = false;
                RequiredFieldValidatorQ1.Enabled = false;
                RequiredFieldValidatorQ2.Enabled = false;
                RequiredFieldValidatorQ3.Enabled = false;
            }
            else
            {
                RadioButtonListQ1.Enabled = true;
                RadioButtonListQ2.Enabled = true;
                RadioButtonListQ3.Enabled = true;
                RequiredFieldValidatorQ1.Enabled = true;
                RequiredFieldValidatorQ2.Enabled = true;
                RequiredFieldValidatorQ3.Enabled = true;
            }
        }
    }

    private static string DeferredMessage
    {
        get { return HttpContext.Current.Session[DeferredMessageKeyName] as string; }
        set { HttpContext.Current.Session[DeferredMessageKeyName] = value; }
    }

    #region Index Chnage Events
    protected void PF_Changed(object sender, EventArgs e)
    {
        int _i = RadioButtonListQ12.SelectedIndex;
        if (_i != -1)
        {
            if (RadioButtonListQ12.SelectedItem.Text == "Yes")
            {
                //SetRadioValidation(true);
                RadioButtonListQ1.Enabled = true;
                RadioButtonListQ2.Enabled = true;
                RadioButtonListQ3.Enabled = true;
                RequiredFieldValidatorQ1.Enabled = true;
                RequiredFieldValidatorQ2.Enabled = true;
                RequiredFieldValidatorQ3.Enabled = true;
                RadioButtonListQ4.Enabled = true;
                RadioButtonListQ5.Enabled = true;
                RadioButtonListQ6.Enabled = true;
                RadioButtonListQ7.Enabled = true;
                RadioButtonListQ8.Enabled = true;
                RadioButtonListQ9.Enabled = true;
                RadioButtonListQ10.Enabled = true;
                RadioButtonListQ11.Enabled = true;
                RadioButtonListQ12.SelectedIndex = 0;

                LabelRawScore_2.Text = ((RadioButtonListQ1.SelectedIndex + 1) +
               (RadioButtonListQ2.SelectedIndex + 1) +
               (RadioButtonListQ3.SelectedIndex + 1) +
               (RadioButtonListQ4.SelectedIndex + 1) +
               (RadioButtonListQ5.SelectedIndex + 1) +
               (RadioButtonListQ6.SelectedIndex + 1) +
               (RadioButtonListQ7.SelectedIndex + 1) +
               (RadioButtonListQ8.SelectedIndex + 1) +
               (RadioButtonListQ9.SelectedIndex + 1) +
               (RadioButtonListQ10.SelectedIndex + 1) +
               (RadioButtonListQ11.SelectedIndex + 1)).ToString().Replace("0", "");
                LabelRawScore.Text = ((RadioButtonListQ1.SelectedIndex + 1) +
               (RadioButtonListQ2.SelectedIndex + 1) +
               (RadioButtonListQ3.SelectedIndex + 1) +
               (RadioButtonListQ4.SelectedIndex + 1) +
               (RadioButtonListQ5.SelectedIndex + 1) +
               (RadioButtonListQ6.SelectedIndex + 1) +
               (RadioButtonListQ7.SelectedIndex + 1) +
               (RadioButtonListQ8.SelectedIndex + 1) +
               (RadioButtonListQ9.SelectedIndex + 1) +
               (RadioButtonListQ10.SelectedIndex + 1) +
               (RadioButtonListQ11.SelectedIndex + 1)).ToString();
            }
            else
            {
                //SetRadioValidation(true);
                RadioButtonListQ1.ClearSelection();
                RadioButtonListQ2.ClearSelection();
                RadioButtonListQ3.ClearSelection();
                RadioButtonListQ1.Enabled = false;
                RadioButtonListQ2.Enabled = false;
                RadioButtonListQ3.Enabled = false;
                RequiredFieldValidatorQ1.Enabled = false;
                RequiredFieldValidatorQ2.Enabled = false;
                RequiredFieldValidatorQ3.Enabled = false;
                RadioButtonListQ4.Enabled = true;
                RadioButtonListQ5.Enabled = true;
                RadioButtonListQ6.Enabled = true;
                RadioButtonListQ7.Enabled = true;
                RadioButtonListQ8.Enabled = true;
                RadioButtonListQ9.Enabled = true;
                RadioButtonListQ10.Enabled = true;
                RadioButtonListQ11.Enabled = true;
                RadioButtonListQ12.SelectedIndex = 1;

                LabelRawScore_2.Text = ((RadioButtonListQ4.SelectedIndex + 1) +
               (RadioButtonListQ5.SelectedIndex + 1) +
               (RadioButtonListQ6.SelectedIndex + 1) +
               (RadioButtonListQ7.SelectedIndex + 1) +
               (RadioButtonListQ8.SelectedIndex + 1) +
               (RadioButtonListQ9.SelectedIndex + 1) +
               (RadioButtonListQ10.SelectedIndex + 1) +
               (RadioButtonListQ11.SelectedIndex + 1)).ToString().Replace("0", "");

                LabelRawScore.Text = ((RadioButtonListQ4.SelectedIndex + 1) +
               (RadioButtonListQ5.SelectedIndex + 1) +
               (RadioButtonListQ6.SelectedIndex + 1) +
               (RadioButtonListQ7.SelectedIndex + 1) +
               (RadioButtonListQ8.SelectedIndex + 1) +
               (RadioButtonListQ9.SelectedIndex + 1) +
               (RadioButtonListQ10.SelectedIndex + 1) +
               (RadioButtonListQ11.SelectedIndex + 1)).ToString();
            }
        }
    }

    protected void Index_Changed(object sender, EventArgs e)
    {
        bool _skipSwitch = false;
        int _i = -1;
        if (rbNoteType.SelectedIndex > -1)
        {
            _i = rbNoteType.SelectedIndex;
        }
        else
        {
            _i = 0;

            if (prevNotesList.SelectedIndex == 0)
            {
                _skipSwitch = true;
                rbNoteType.SelectedIndex = _i;
                rbNoteType.Items[0].Enabled = false;
                rbNoteType.Items[1].Enabled = false;
                rbNoteType.Items[2].Enabled = false;
                rbNoteType.Items[3].Enabled = false;
                clear_form();
            }
        }
        if (_skipSwitch == false)
        {
            switch (_i.ToString())
            {
                case null:
                    break;
                case "0":
                    if (prevNotesList.SelectedIndex == 0)
                    {
                        rbNoteType.Items[0].Enabled = true;
                        rbNoteType.Items[1].Enabled = false;
                        rbNoteType.Items[2].Enabled = false;
                        rbNoteType.Items[3].Enabled = false;
                        rbNoteType.SelectedIndex = 0;
                        prevNoteID.Value = "self";
                    }
                    else
                    {
                        if (rbNoteType.SelectedIndex == 1)
                        {
                            rbNoteType.Items[0].Enabled = false;
                            rbNoteType.Items[1].Enabled = false;
                            rbNoteType.Items[2].Enabled = false;
                            rbNoteType.Items[3].Enabled = true;
                            rbNoteType.SelectedIndex = 3;
                        }
                        else
                        {
                            rbNoteType.Items[0].Enabled = false;
                            rbNoteType.Items[1].Enabled = true;
                            rbNoteType.Items[2].Enabled = true;
                            rbNoteType.Items[3].Enabled = false;
                            rbNoteType.SelectedIndex = -1;
                        }
                    }
                    break;
                case "1":
                    rbNoteType.Items[0].Enabled = false;
                    rbNoteType.Items[1].Enabled = true;
                    rbNoteType.Items[2].Enabled = true;
                    rbNoteType.Items[3].Enabled = false;
                    break;
                case "2":
                    rbNoteType.Items[0].Enabled = false;
                    rbNoteType.Items[1].Enabled = false;
                    rbNoteType.Items[2].Enabled = false;
                    rbNoteType.Items[3].Enabled = false;
                    rbNoteType.SelectedIndex = 3;
                    break;
                default:
                    rbNoteType.Items[0].Enabled = false;
                    rbNoteType.Items[1].Enabled = true;
                    rbNoteType.Items[2].Enabled = true;
                    rbNoteType.Items[3].Enabled = false;
                    rbNoteType.SelectedIndex = -1;
                    break;
            }
        }
        if (prevNotesList.SelectedIndex == 0)
        {
            rbNoteType.SelectedIndex = 0;
            rbNoteType.Items[0].Enabled = false;
            rbNoteType.Items[1].Enabled = false;
            rbNoteType.Items[2].Enabled = false;
            rbNoteType.Items[3].Enabled = false;
            clear_form();
        }
        if (prevNotesList.SelectedValue.Length > 0)
        {
            string char2 = prevNotesList.SelectedValue.Substring(prevNotesList.SelectedValue.Length - 3, 2);
            if (char2 == "1,")
            {
                hasDischarge = true;

                rbNoteType.Items[0].Enabled = false;
                rbNoteType.Items[1].Enabled = false;
                rbNoteType.Items[2].Enabled = false;
                rbNoteType.Items[3].Enabled = true;
                rbNoteType.SelectedIndex = 3;
            }
        }
    }
    #endregion
    /// <summary>
    /// In addition to the normal actions taken in Page_Load,
    /// instantiate the MDWS Web Service (T)ransfer (O)bject.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void Page_Load(object sender, EventArgs e)
    {
        try
        {
            this.CheckActiveStatus(_surveyTypeId);

            LabelInstrumentTitle.Text = GetInstrumentTitle(_surveyTypeId);
            SetQuestionLabels();

            //Confirm instrument is active - if not, a redirect will occur.
            _tbiInstrumentManager.TbiServiceTo = base.GetTBIServiceTo();
            if (_tbiInstrumentManager.TbiServiceTo == null)
            {
                Logging.WriteLogToFile("PhysicalFunctionwMobilityAid.Page_Load(): _tbiInstrumentManager.TbiServiceTo == null");
                //Redirect to message that session is ended and need to log back in from CPRS.
                Response.Redirect("Warning.aspx?err=2");
            }

            LabelBreadCrumb.Text = "TBI Instruments > Instrument Associations > " + selectedInstrumentType.Name;
            if (!IsPostBack)
            {
                string _snum = string.Empty;
                string _notesIDString = string.Empty;
                base.AddtoViewStateTBIServiceTo(_tbiInstrumentManager.TbiServiceTo);

                if (instrumentType.Status != null)
                {
                    _tbiInstrumentManager.TbiServiceTo.SelectedInstrumentType = instrumentType;
                }

                _snum = _tbiInstrumentManager.TbiServiceTo.PatientSnum;

                LabelPatient.Text = BusinessHelper.FixStringToPreventXss(_tbiInstrumentManager.TbiServiceTo.PatientName);
                LabelSSN.Text = BusinessHelper.FixStringToPreventXss(_tbiInstrumentManager.TbiServiceTo.PatientSnum.Trim().Length == 9 ? String.Format("{0:000-00-0000}", int.Parse(_tbiInstrumentManager.TbiServiceTo.PatientSnum)) : _tbiInstrumentManager.TbiServiceTo.PatientSnum);

                Label labelUser = (Label)Master.FindControl("LabelCurrentUser");
                if (labelUser != null)
                {
                    labelUser.Text = BusinessHelper.FixStringToPreventXss(_tbiInstrumentManager.TbiServiceTo.UserName);
                }

                if (!string.IsNullOrEmpty(_snum))
                {
                    string patICN = patientManager.GetPatientICNBySnum(_snum);

                    if (!string.IsNullOrEmpty(patICN))
                    {
                        ViewState["PatientICN"] = patICN;
                        RefreshSurvey(patICN);
                    }
                    else
                    {
                        throw new ArgumentException("Patient with this SSN does not exist.");
                    }

                    try
                    {
                        StringBuilder _addToICN = new StringBuilder();
                        _addToICN.Append(patICN);
                        _addToICN.Append("2");
                        prevPhysicalFunctionwMobilityAid = _tbiInstrumentManager.PreviousM2PINoteTypes(_addToICN.ToString());
                        prevNotesList.DataSource = prevPhysicalFunctionwMobilityAid;
                        prevNotesList.DataBind();
                    }
                    catch (Exception ex)
                    {
                        //The return from the udfn is empty
                        Exception _tbilogerror = HandleTBIException(ex, "PhysicalFunctionwMobilityAid.aspx", "100027", "_tbiInstrumentManager.PreviousM2PINoteTypes(patICN)");
                    }
                    rbNoteType.DataBind();
                    rbNoteType.Items[1].Enabled = false;
                    rbNoteType.Items[2].Enabled = false;
                    rbNoteType.Items[3].Enabled = false;
                    if (SurveyDate.Value.Length < 1)
                    {
                        SurveyDate.Value = System.DateTime.Now.ToShortDateString();
                    }
                    if (_survey != null && !_survey.isNew) { SetUpSurvey(_survey); }
                    if (prevPhysicalFunctionwMobilityAid != null)
                    {
                        if (prevPhysicalFunctionwMobilityAid.DefaultView.Count > 0)
                        {
                            _notesIDString = prevPhysicalFunctionwMobilityAid.Rows[0].ItemArray[0].ToString();
                            string[] _vals = _notesIDString.Split(',');

                            if (_vals[3] != "0")
                            {
                                rbNoteType.Items[0].Enabled = false;
                                rbNoteType.Items[1].Enabled = false;
                                rbNoteType.Items[2].Enabled = false;
                                rbNoteType.Items[3].Enabled = false;
                                prevNotesList.SelectedIndex = 0;
                                rbNoteType.SelectedIndex = 0;
                            }
                            else if (_vals[2] != "0")
                            {
                                rbNoteType.Items[0].Enabled = false;
                                rbNoteType.Items[1].Enabled = false;
                                rbNoteType.Items[2].Enabled = false;
                                rbNoteType.Items[3].Enabled = true;
                                rbNoteType.SelectedIndex = 3;
                            }
                            else if (_vals[1] != "0")
                            {
                                rbNoteType.Items[0].Enabled = false;
                                rbNoteType.Items[1].Enabled = true;
                                rbNoteType.Items[2].Enabled = true;
                                rbNoteType.Items[3].Enabled = false;
                            }
                            else if (_vals[0] != "0")
                            {
                                rbNoteType.Items[0].Enabled = false;
                                rbNoteType.Items[1].Enabled = true;
                                rbNoteType.Items[2].Enabled = true;
                                rbNoteType.Items[3].Enabled = false;
                            }
                        }
                        else
                        {
                            if (isFollowUp)
                            {
                                rbNoteType.Items[0].Enabled = false;
                                rbNoteType.Items[1].Enabled = false;
                                rbNoteType.Items[2].Enabled = false;
                                rbNoteType.Items[3].Enabled = true;
                                rbNoteType.SelectedIndex = 3;
                            }
                            else
                            {
                                if (_notesIDString == "")
                                {
                                    rbNoteType.Items[0].Selected = true;
                                    rbNoteType.Items[0].Enabled = false;
                                    rbNoteType.Items[1].Enabled = false;
                                    rbNoteType.Items[2].Enabled = false;
                                    rbNoteType.Items[3].Enabled = false;
                                }
                                else
                                {
                                    rbNoteType.Items[0].Enabled = false;
                                    rbNoteType.Items[1].Enabled = true;
                                    rbNoteType.Items[2].Enabled = true;
                                    rbNoteType.Items[3].Enabled = false;
                                }
                            }
                        }
                    }
                    string referrer = string.Empty;
                    if (Request.UrlReferrer != null)
                    {
                        referrer = Request.UrlReferrer.PathAndQuery;
                    }
                    ViewState["referrer"] = referrer;
   
                }

            }
            else
            {
                if (!IsPostBack)
                {
                    if (Session["NoteTypeMob"] != null)
                    {
                        rbNoteType.SelectedIndex = Convert.ToInt32(Session["NoteTypeMob"].ToString());
                    }
                    if (Session["IOCNumberMob"] != null)
                    {
                        prevNotesList.SelectedIndex = Convert.ToInt32(Session["IOCNumberMob"].ToString());
                    }
                }
            }
            if (prevNotesList.SelectedIndex == -1)
            {
                rbNoteType.Items[0].Enabled = false;
                rbNoteType.Items[1].Enabled = false;
                rbNoteType.Items[2].Enabled = false;
                rbNoteType.Items[3].Enabled = false;
            }
            if (RadioButtonListQ12.SelectedIndex > -1)
            {
                if (RadioButtonListQ12.SelectedIndex == 1)
                {
                    RadioButtonListQ1.Enabled = false;
                    RadioButtonListQ2.Enabled = false;
                    RadioButtonListQ3.Enabled = false;
                    RequiredFieldValidatorQ1.Enabled = false;
                    RequiredFieldValidatorQ2.Enabled = false;
                    RequiredFieldValidatorQ3.Enabled = false;
                }
                else
                {
                    RadioButtonListQ1.Enabled = true;
                    RadioButtonListQ2.Enabled = true;
                    RadioButtonListQ3.Enabled = true;
                    RequiredFieldValidatorQ1.Enabled = true;
                    RequiredFieldValidatorQ2.Enabled = true;
                    RequiredFieldValidatorQ3.Enabled = true;
                }
            }
            string instrumentTitle = GetInstrumentTitle(_surveyTypeId);
            LabelInstrumentTitle.Text = instrumentTitle;
            Page.Title = "TBI Instruments - " + instrumentTitle;

            QuestionList = GetAllQuestionsForSurvey();

            // Set control values for Diagnosis Question
            ctrlDiagnosis.QuestionText = GetQuestionText("DX");
            ctrlDiagnosis.SurveyTypeCode = HiddenSurveyType.Value;

            // Set labels, etc
            cntlRehabilitationProviderSelector.QuestionText = GetQuestionText("RP");
            cntlRehabilitationProviderSelector.SurveyTypeCode = HiddenSurveyType.Value;

            cntlTypeOfServiceSelector.QuestionText = GetQuestionText("TS");
            cntlTypeOfServiceSelector.SurveyTypeCode = HiddenSurveyType.Value;
            if (Session["NoteTypeMob"] != null)
            {
                if (Session["NoteTypeMob"].ToString() == "1")
                {

                    rbNoteType.Items[1].Enabled = true;
                    rbNoteType.Items[2].Enabled = true;
                }
            }
            if (prevNotesList.SelectedIndex == -1)
            {
                prevNotesList.SelectedIndex = 0;
                rbNoteType.Items[0].Selected = true;
            }
        }
        catch (Exception ex2)
        {
            //Redirect to message that session is ended and need to log back in from CPRS.
            Exception _tbilogerror = HandleTBIException(ex2, "PhysicalFunctionwMobilityAid.aspx", "100027", "Page_Load()");
            Response.Redirect("Warning.aspx?err=2");
        }
    }

    protected string GetQuestionText(string questionId)
    {
        foreach (STD_QUESTION ques in QuestionList)
        {
            if (ques.QUESTION_NUMBER.ToLower() == questionId.ToLower())
            {
                return ques.QUESTION_TEXT;
            }
        }
        return "";
    }
    protected override void LoadViewState(object savedState)
    {
        base.LoadViewState(savedState);
        string surveyXml = (string)ViewState["surveyXml"];
        _survey = SerializerUtil.Deserialize<SURVEY>(surveyXml);
    }

    protected override object SaveViewState()
    {
        ViewState["surveyXml"] = _survey.Serialize();
        return base.SaveViewState();
    }

    public void btnSaveSurveyDraft_Click(object sender, EventArgs e)
    {
        Int32 status = 0;
        Session["NoteTypeMob"] = rbNoteType.SelectedIndex.ToString();
        Session["IOCNumberMob"] = prevNotesList.SelectedIndex.ToString();
        SaveFailMessage = "Save Failed. Please press " + btnSaveSurveyDraft.Text + " button again to avoid data loss.";
        SaveCompleteSurvey(ref status);
        Response.Redirect("PhysicalFunctionwMobilityAid.aspx");
        //Response.Redirect(Request.Url.PathAndQuery, false);
    }

    protected void btnSubmit_Click(object sender, EventArgs e)
    {
        Int32 status = 0;
        SaveFailMessage = "Save Failed. Please press " + btnSubmitSurvey.Text + " button again to avoid data loss.";
     
        SaveCompleteSurvey(ref status);
        int instancenumber = 1;

        if (prevNotesList.SelectedIndex != -1)
        {
            instancenumber = prevNotesList.SelectedIndex;
        }

        if (status > 0)
        {
            preventNotification = true;
            Session["survey"] = _survey;
            Session["rawScore"] = hiddenRawScore.Value;
            Session["MobilityAidCopyright"] = lblCopyRight.Text;
            Session["NoteTypeMob"] = rbNoteType.SelectedIndex.ToString();
            Session["IOCNumberMob"] = prevNotesList.SelectedIndex.ToString();
            if (instancenumber == 0) { instancenumber = prevNotesList.Items.Count; }
            Session["InstanceNumber"] = instancenumber;
            Response.Redirect("InstrumentSummaryNote.aspx", false);
        }
        else
        {
            Response.Redirect(Request.Url.PathAndQuery, false);
        }
    }

    /// <summary>
    /// Cancel button clicked.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnCancel_Click(object sender, EventArgs e)
    {
        ViewState["surveyXml"] = null;
        ViewState["PatientICN"] = null;
        ViewState["referrer"] = null;
        Session.Remove("survey");
        Response.Redirect("Instrument.aspx", false);
        //this.ClientScript.RegisterStartupScript(typeof(Page), "closePage", "<script type='text/javascript'> window.open('','_self','');window.close(); </script>");
    }

    /// <summary>
    /// Inactive timer firing.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void InActiveTimer_Tick(object sender, EventArgs e)
    {
        Int32 status = 0;
        SaveFailMessage = "Save Failed. Please press " + btnSaveSurveyDraft.Text + " button again to avoid data loss.";
        Session["NoteTypeMob"] = rbNoteType.SelectedIndex.ToString();
        Session["IOCNumberMob"] = prevNotesList.SelectedIndex.ToString();
        Page.Validate();

        if (Page.IsValid)
        {
            SaveCompleteSurvey(ref status);
            //SetUpSurvey(_survey);
            Response.Redirect("PhysicalFunctionwMobilityAid.aspx");
        }
        else
        {
            SaveFailMessage = "Auto-Save Validation Failed. Please complete required fields in the survey and press " + btnSaveSurveyDraft.Text + " button again to avoid data loss.";
        }
    }

    #endregion Protected Methods

    #region Private Methods

    private void clear_form()
    {
        if (ViewState["PatientICN"] != null) { RefreshSurvey(ViewState["PatientICN"].ToString()); }
        RadioButtonListQ1.ClearSelection();
        RadioButtonListQ2.ClearSelection();
        RadioButtonListQ3.ClearSelection();
        RadioButtonListQ4.ClearSelection();
        RadioButtonListQ5.ClearSelection();
        RadioButtonListQ6.ClearSelection();
        RadioButtonListQ7.ClearSelection();
        RadioButtonListQ8.ClearSelection();
        RadioButtonListQ9.ClearSelection();
        RadioButtonListQ10.ClearSelection();
        RadioButtonListQ11.ClearSelection();
        RadioButtonListQ12.ClearSelection();
    }

    private void RefreshSurvey(string patientICN)
    {
        var surveys = _tbiInstrumentManager.SelectByPatientICNAndSurveyType(patientICN, _surveyTypeId, true).ToList();
        if (surveys.Count > 0)
        {
            _survey = surveys.First();
        }
        else
        {
            _survey = new SURVEY();
        }
        _survey.SetAsChangeTrackingRoot();
    }

    private void SaveCompleteSurvey(ref Int32 status)
    {
             string patientICN = String.Empty;
             status = 0;

        try
        {
            //Retrieve patient's ICN from the session variable
            if (ViewState["PatientICN"] != null)
            {
                patientICN = ViewState["PatientICN"].ToString();
                if (String.IsNullOrEmpty(patientICN.Trim()))
                {
                    Logging.WriteLogToFile("PhysicalFunctionwMobilityAid.SaveCompletedSurvey(): WarningRedirect: String.IsNullOrEmpty(patientICN.Trim()");
                    //Lost state. Redirect to message that need to log back in from CPRS.
                    Response.Redirect("Warning.aspx?err=2", false);
                }
            }
            else
            {
                Logging.WriteLogToFile("PhysicalFunctionwMobilityAid.SaveCompletedSurvey(): WarningRedirect: ViewState[PatientICN] != null");
                //Lost state. Redirect to message that need to log back in from CPRS.
                Response.Redirect("Warning.aspx?err=2");
            }

            if (_survey != null)
            {
                if (_survey.isNew)
                {
                    //Ensure that a concurrent session hasn't already inserted a record for this survey
                    //var surveys = _tbiInstrumentManager.SelectByPatientICNAndSurveyType(patientICN, _surveyTypeId, true).ToList();

                    //if (surveys.Count > 0)
                    //{
                    //    Logging.WriteLogToFile("PhysicalFunctionwMobilityAid.SaveCompletedSurvey(): WarningRedirect: surveys.Count > 0");
                    //    //A concurrent session has already inserted a record for this survey and it is not new anymore.
                    //    Response.Redirect("Warning.aspx?err=9", false);
                    //}
                    //else
                    //{
                        _survey.SURVEY_STATUS = "inprocess";
                        _survey.SetAsInsertOnSubmit();
                        _survey.patient_ICN = patientICN;
                        _survey.STD_SURVEY_TYPE_ID = _surveyTypeId;
                        _survey.SURVEY_DATE = DateTime.Today;

                        //Save survey if it's new before adding any responses
                        SuppressSaveMessage = true;
                        _tbiInstrumentManager.Update(_survey);
                        SuppressSaveMessage = false;

                        RefreshSurvey(patientICN);
                    //}
                }

                SaveSurvey(ref _survey);
              
                _survey.SetAsUpdateOnSubmit();
                status = _tbiInstrumentManager.Update(_survey);
                if (status != 0)
                {
                    ((RegistryInstrumentMaster)Master).SetDirtyFlag(false);
                    RefreshSurvey(patientICN);
                    SuppressSaveMessage = false;
                }
                
            }
        }
        catch (Exception ex)
        {
            Exception _tbilogerror = HandleTBIException(ex, "PhysicalFunctionwMobilityAid.aspx", "100027", "SaveCompleteSurvey()");
        }
        finally
        {
            if (status == 0)
                Helpers.SavePageToCache(this, FailedFormValuesName);
            else
                Session[FailedFormValuesName] = null;//clear out the cached version on success
        }
    }

    private void SaveText(SURVEY survey, TextBox textBox, string questionNumber)
    {
        List<STD_QUESTION_CHOICE> availableChoices = VeteransAffairs.Registries.QuestionChoiceRetriever.GetQuestionChoices(questionNumber);
        string inputText = textBox.Text.Trim();
        int id = availableChoices.FirstOrDefault(item => item.CHOICE_SORT_ORDER == 0).STD_QUESTION_CHOICE_ID;
        SaveGeneric(survey, id, inputText);
    }

    //Expects to caller to understand the impact of saving a simple item - may cause questions to have more than 1 response
    private void SaveGeneric(SURVEY survey, int id, string text)
    {
        SURVEY_RESULT currentResult = survey.SURVEY_RESULTs.FirstOrDefault(item => item.STD_QUESTION_CHOICE_ID == id);
        if (null != currentResult)
        {
            if (currentResult.RESULT_TEXT != text)
            {
                currentResult.SetAsUpdateOnSubmit();
                currentResult.RESULT_TEXT = text;
            }
            else
            {
                currentResult.SetAsNoChangeOnSubmit();
            }
        }
        else if (text != string.Empty)
        {
            SURVEY_RESULT result = new SURVEY_RESULT();
            result.RESULT_TEXT = text;
            result.STD_QUESTION_CHOICE_ID = id;
            survey.SURVEY_RESULTs.Add(result);
        }
    }

    /// <summary>
    /// Save survey.
    /// </summary>
    /// <param name="survey"></param>
    private void SaveSurvey(ref SURVEY survey)
    {
        List<STD_QUESTION> questions = GetAllQuestionsForSurvey();
        //first, mark all current answers for deletion
        survey.SetAsChangeTrackingRoot();
        foreach (SURVEY_RESULT tempResult in survey.SURVEY_RESULTs)
            tempResult.SetAsDeleteOnSubmit();
        //now determine whether to add or update each item
        //Helpers.SaveSingleSelect(survey, rbNoteType, "-1");
        List<STD_QUESTION_CHOICE> listChoice = _tbiInstrumentManager.GetChoicesByQuestionNumberandSurveyType("-11", "PPMA");

        int iRawScore = 0;
        int iSurveyDate = 0;
        if (listChoice.Count > 0)
        {
            foreach (var choice in listChoice)
            {
                switch (choice.CHOICE_NAME)
                {
                    case "Raw Score":
                        iRawScore = choice.STD_QUESTION_CHOICE_ID;
                        break;
                    case "Initial Note Date":
                        iSurveyDate = choice.STD_QUESTION_CHOICE_ID;
                        break;
                    default:
                        break;
                }
            }
        }
        listChoice = _tbiInstrumentManager.GetChoicesByQuestionNumberandSurveyType("-11", "PPMA");
        if (listChoice.Count > 0)
        {
            int iprevNoteID = listChoice[0].STD_QUESTION_CHOICE_ID;
            SaveGeneric(survey, iprevNoteID, prevNoteID.Value.ToString());
        }
        //Survey questions

        // Question DX
        _surveyResult = new SURVEY_RESULT();
        try
        {
            // Add Question DX choice
            _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(ctrlDiagnosis.GetSelectedId());
            _surveyResult.RESULT_TEXT = ctrlDiagnosis.GetSelectedResultText();
            survey.SURVEY_RESULTs.Add(_surveyResult);
        }
        catch (Exception surveyEx)
        {
            Exception _tbilogerror = HandleTBIException(surveyEx, "PhysicalFunctionwMobilityAid.aspx", "100027", "SaveSurvey() - Question DX");
        }

        // Question RP
        _surveyResult = new SURVEY_RESULT();
        try
        {
            // Add Question DX choice
            _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(cntlRehabilitationProviderSelector.GetSelectedId());
            _surveyResult.RESULT_TEXT = cntlRehabilitationProviderSelector.GetSelectedResultText();
            survey.SURVEY_RESULTs.Add(_surveyResult);
        }
        catch (Exception surveyEx)
        {
            Exception _tbilogerror = HandleTBIException(surveyEx, "PhysicalFunctionwMobilityAid.aspx", "100027", "SaveSurvey() - Question RP");
        }

        // Question TS
        _surveyResult = new SURVEY_RESULT();
        try
        {
            // Add Question DX choice
            _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(cntlTypeOfServiceSelector.GetSelectedId());
            _surveyResult.RESULT_TEXT = cntlTypeOfServiceSelector.GetSelectedResultText();
            survey.SURVEY_RESULTs.Add(_surveyResult);
        }
        catch (Exception surveyEx)
        {
            Exception _tbilogerror = HandleTBIException(surveyEx, "PhysicalFunctionwMobilityAid.aspx", "100027", "SaveSurvey() - Question TS");
        }

        // Question - Note Type
        if (rbNoteType.SelectedIndex > -1)
        {
            STD_QUESTION question0 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "-1");
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question Note Typoe choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rbNoteType.SelectedValue);
                _surveyResult.RESULT_TEXT = rbNoteType.SelectedItem.Text.Trim();
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "PhysicalFunctionwMobilityAid.aspx", "100027", "SaveSurvey() - NOTETTYPE");
            }
        }
        // Question 1 - 
        if (RadioButtonListQ1.SelectedIndex > -1)
        {
            STD_QUESTION question1 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "PFC6");
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question 1 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(RadioButtonListQ1.SelectedValue);
                _surveyResult.RESULT_TEXT = RadioButtonListQ1.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "PhysicalFunctionwMobilityAid.aspx", "100027", "SaveSurvey() - Question1");
            }
        }
        // Question 2 - 
        if (RadioButtonListQ2.SelectedIndex > -1)
        {
            STD_QUESTION question2 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "PFC29");
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question 2 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(RadioButtonListQ2.SelectedValue);
                _surveyResult.RESULT_TEXT = RadioButtonListQ2.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "PhysicalFunctionwMobilityAid.aspx", "100027", "SaveSurvey() - Question2");
            }
        }

        // Question 3 - 
        if (RadioButtonListQ3.SelectedIndex > -1)
        {
            STD_QUESTION question3 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "PF_17");
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question 3 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(RadioButtonListQ3.SelectedValue);
                _surveyResult.RESULT_TEXT = RadioButtonListQ3.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "PhysicalFunctionwMobilityAid.aspx", "100027", "SaveSurvey() - Question3");
            }
        }

        // Question 4 - 
        if (RadioButtonListQ4.SelectedIndex > -1)
        {
            STD_QUESTION question4 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "PFA55");
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question 4 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(RadioButtonListQ4.SelectedValue);
                _surveyResult.RESULT_TEXT = RadioButtonListQ4.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "PhysicalFunctionwMobilityAid.aspx", "100027", "SaveSurvey() - Question4");
            }
        }

        // Question 5 - 
        if (RadioButtonListQ5.SelectedIndex > -1)
        {
            STD_QUESTION question5 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "PFC45");
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question 5 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(RadioButtonListQ5.SelectedValue);
                _surveyResult.RESULT_TEXT = RadioButtonListQ5.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "PhysicalFunctionwMobilityAid.aspx", "100027", "SaveSurvey() - Question6");
            }
        }

        // Question 6 - 
        if (RadioButtonListQ6.SelectedIndex > -1)
        {
            STD_QUESTION question6 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "PFC53");
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question 5 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(RadioButtonListQ6.SelectedValue);
                _surveyResult.RESULT_TEXT = RadioButtonListQ6.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "PhysicalFunctionwMobilityAid.aspx", "100027", "SaveSurvey() - Question7");
            }
        }

        // Question 7 - 
        if (RadioButtonListQ7.SelectedIndex > -1)
        {
            STD_QUESTION question7 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "PFA9");
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question 5 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(RadioButtonListQ7.SelectedValue);
                _surveyResult.RESULT_TEXT = RadioButtonListQ7.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "PhysicalFunctionwMobilityAid.aspx", "100027", "SaveSurvey() - Question7");
            }
        }

        // Question 8 - 
        if (RadioButtonListQ8.SelectedIndex > -1)
        {
            STD_QUESTION question8 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "PFA20");
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question 8 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(RadioButtonListQ8.SelectedValue);
                _surveyResult.RESULT_TEXT = RadioButtonListQ8.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "PhysicalFunctionwMobilityAid.aspx", "100027", "SaveSurvey() - Question8");
            }
        }

        // Question 9 - 
        if (RadioButtonListQ9.SelectedIndex > -1)
        {
            STD_QUESTION question9 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "PFA12");
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question 9 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(RadioButtonListQ9.SelectedValue);
                _surveyResult.RESULT_TEXT = RadioButtonListQ9.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "PhysicalFunctionwMobilityAid.aspx", "100027", "SaveSurvey() - Question9");
            }
        }

        // Question 10 - 
        if (RadioButtonListQ10.SelectedIndex > -1)
        {
            STD_QUESTION question10 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "PF_23");
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question 10 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(RadioButtonListQ10.SelectedValue);
                _surveyResult.RESULT_TEXT = RadioButtonListQ10.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "PhysicalFunctionwMobilityAid.aspx", "100027", "SaveSurvey() - Question10");
            }
        }

        // Question 11 - 
        if (RadioButtonListQ11.SelectedIndex > -1)
        {
            STD_QUESTION question11 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "PF_53");
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question 10 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(RadioButtonListQ11.SelectedValue);
                _surveyResult.RESULT_TEXT = RadioButtonListQ11.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "PhysicalFunctionwMobilityAid.aspx", "100027", "SaveSurvey() - Question11");
            }
        }

        // Question Support - 
        if (RadioButtonListQ12.SelectedIndex > -1)
        {
            STD_QUESTION question12 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "Support");
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question 12 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(RadioButtonListQ12.SelectedValue);
                _surveyResult.RESULT_TEXT = RadioButtonListQ12.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "PhysicalFunctionwMobilityAid.aspx", "100027", "SaveSurvey() - Question12");
            }
        }
        //survey.STD_SURVEY_TYPE_ID = _surveyTypeId;

    }// END SaveSurvey

    /// <summary>
    /// Get all questions for this survey
    /// </summary>
    /// <returns></returns>
    private List<STD_QUESTION> GetAllQuestionsForSurvey()
    {
        return _tbiInstrumentManager.SelectAllQuestions(_surveyTypeId).ToList();
    }

    private void SetNoteInformation(SURVEY_RESULT result)
    {
        rbNoteType.Text = result.STD_QUESTION_CHOICE_ID.ToString();
        rbNoteType.Text = result.STD_QUESTION_CHOICE.CHOICE_TEXT;
    }

    private void SetRadioElement(SURVEY_RESULT result, RadioButtonList radioButton)
    {
        if (result.STD_QUESTION_CHOICE.CHOICE_TEXT != "Yes" && result.STD_QUESTION_CHOICE.CHOICE_TEXT != "No")
        {
            if (result.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue)
            {
                radioButton.SelectedIndex = result.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.Value - 1;
            }
            else
            {
                radioButton.SelectedIndex = -1;
            }
        }
        else
        {
            if (result.STD_QUESTION_CHOICE.CHOICE_TEXT == "Yes")
            {
                radioButton.SelectedIndex = 0;
            }
            else
            {
                radioButton.SelectedIndex = 1;
            }
        }
    }

    private void SetTextBoxElement(SURVEY_RESULT survey, TextBox textBox)
    {
        textBox.Text = survey.RESULT_TEXT;
    }

    private void SetRadioValidation(bool _isSet)
    {
        bool _isFalse = false;
        if (IsPostBack)
        {
            if (_isSet == true)
            {
                RadioButtonListQ1.SelectedIndex = -1;
                RadioButtonListQ2.SelectedIndex = -1;
                RadioButtonListQ3.SelectedIndex = -1;
                RadioButtonListQ1.Enabled = _isSet;
                RadioButtonListQ2.Enabled = _isSet;
                RadioButtonListQ3.Enabled = _isSet;
            }
        }
        if (RadioButtonListQ12.SelectedIndex == 0)
        {
            _isSet = _isFalse;
        }
        RadioButtonListQ4.Enabled = _isSet;
        RequiredFieldValidatorQ4.Enabled = _isSet;
        RadioButtonListQ5.Enabled = _isSet;
        RequiredFieldValidatorQ5.Enabled = _isSet;
        RadioButtonListQ6.Enabled = _isSet;
        RequiredFieldValidatorQ6.Enabled = _isSet;
        RadioButtonListQ7.Enabled = _isSet;
        RequiredFieldValidatorQ7.Enabled = _isSet;
        RadioButtonListQ8.Enabled = _isSet;
        RequiredFieldValidatorQ8.Enabled = _isSet;
        RadioButtonListQ9.Enabled = _isSet;
        RequiredFieldValidatorQ9.Enabled = _isSet;
        RadioButtonListQ10.Enabled = _isSet;
        RequiredFieldValidatorQ10.Enabled = _isSet;
        RadioButtonListQ11.Enabled = _isSet;
        RequiredFieldValidatorQ11.Enabled = _isSet;
    }

    /// <summary>
    /// Initialize/setup controls
    /// </summary>
    /// <param name="survey"></param>
    private void SetUpSurvey(SURVEY survey)
    {
        try
        {
            foreach (var sResult in survey.SURVEY_RESULTs)
            {
                switch (sResult.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER)
                {
                    case "DX":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                        {
                            ctrlDiagnosis.SelectedChoiceId = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();

                            if (sResult.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower().Contains("other"))
                            {
                                ctrlDiagnosis.SetOtherDescriptionText(sResult.RESULT_TEXT);
                            }
                        }
                        else
                        {
                            ctrlDiagnosis.SelectedChoiceId = null;
                        }
                        break;
                    case "RP":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                        {
                            cntlRehabilitationProviderSelector.SelectedChoiceId = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        }
                        else
                        {
                            cntlRehabilitationProviderSelector.SelectedChoiceId = null;
                        }
                        break;
                    case "TS":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                        {
                            cntlTypeOfServiceSelector.SelectedChoiceId = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();

                            if (sResult.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower().Contains("other"))
                            {
                                cntlTypeOfServiceSelector.SetOtherDescriptionText(sResult.RESULT_TEXT);
                            }
                        }
                        else
                        {
                            cntlTypeOfServiceSelector.SelectedChoiceId = null;
                        }
                        break;
                    case "-1":
                        if (sResult.STD_QUESTION_CHOICE.CHOICE_NAME != null)
                        {
                            if (sResult.STD_QUESTION_CHOICE.CHOICE_NAME.Trim() == "Initial")
                            {
                                rbNoteType.Items[0].Enabled = false;
                                rbNoteType.Items[1].Enabled = true;
                                rbNoteType.Items[2].Enabled = true;
                                rbNoteType.Items[3].Enabled = false;
                            }
                            else if (sResult.STD_QUESTION_CHOICE.CHOICE_NAME.Trim() == "Interim")
                            {
                                rbNoteType.Items[0].Enabled = false;
                                rbNoteType.Items[1].Enabled = true;
                                rbNoteType.Items[2].Enabled = true;
                                rbNoteType.Items[3].Enabled = false;
                            }
                            else if (sResult.STD_QUESTION_CHOICE.CHOICE_NAME.Trim() == "Discharge")
                            {
                                rbNoteType.Items[0].Enabled = false;
                                rbNoteType.Items[1].Enabled = false;
                                rbNoteType.Items[2].Enabled = false;
                                rbNoteType.Items[3].Enabled = true;
                                rbNoteType.SelectedIndex = 3;
                            }
                            else if (sResult.STD_QUESTION_CHOICE.CHOICE_NAME.Trim() == "FollowUp")
                            {
                                rbNoteType.Items[0].Enabled = false;
                                rbNoteType.Items[1].Enabled = false;
                                rbNoteType.Items[2].Enabled = false;
                                rbNoteType.Items[3].Enabled = false;
                                rbNoteType.SelectedIndex = 3;
                                isFollowUp = true;
                            }
                            else
                            {
                                SetRadioElement(sResult, rbNoteType);
                            }
                        }
                        else
                        {
                            SetRadioElement(sResult, rbNoteType);
                        }
                        break;
                    case "Raw Score":
                        SetLabelElement(sResult, LabelRawScore);
                        break;
                    case "CopyRight":
                        SetLabelElement(sResult, lblCopyRight);
                        Session["MobilityAidCopyright"] = lblCopyRight.Text;
                        break;
                    case "-11": SurveyDate.Value = DateTime.Now.ToString(); break;
                    case "-111":
                        break;
                    case "PFC6": SetRadioElement(sResult, RadioButtonListQ1); break;
                    case "PFC29": SetRadioElement(sResult, RadioButtonListQ2); break;
                    case "PF_17": SetRadioElement(sResult, RadioButtonListQ3); break;
                    case "PFA55": SetRadioElement(sResult, RadioButtonListQ4); break;
                    case "PFC45": SetRadioElement(sResult, RadioButtonListQ5); break;
                    case "PFC53": SetRadioElement(sResult, RadioButtonListQ6); break;
                    case "PFA9": SetRadioElement(sResult, RadioButtonListQ7); break;
                    case "PFA20": SetRadioElement(sResult, RadioButtonListQ8); break;
                    case "PFA12": SetRadioElement(sResult, RadioButtonListQ9); break;
                    case "PF_23": SetRadioElement(sResult, RadioButtonListQ10); break;
                    case "PF_53": SetRadioElement(sResult, RadioButtonListQ11); break;
                    case "Support": SetRadioElement(sResult, RadioButtonListQ12); break;
                }
            }
        }
        catch (Exception ex)
        {
            Exception _tbilogerror = HandleTBIException(ex, "PhysicalFunctionwMobilityAid.aspx", "100027", "SetUpSurvey()");
        }
    }

    private void SetLabelElement(SURVEY_RESULT survey, Label label)
    {
        label.Text = survey.RESULT_TEXT;
    }

    private void SetQuestionLabels()
    {
        List<STD_QUESTION> questions = VeteransAffairs.Registries.QuestionChoiceRetriever.GetQuestions();
        NoteTypeLabel.Text = questions.First(q => q.QUESTION_NUMBER == "-1").QUESTION_TEXT + ":";
        Q1Label.Text = "PFC6 - " + questions.First(q => q.QUESTION_NUMBER == "PFC6").QUESTION_TEXT;
        Q2Label.Text = "PFC29 - " + questions.First(q => q.QUESTION_NUMBER == "PFC29").QUESTION_TEXT;
        Q3Label.Text = "PF 17 - " + questions.First(q => q.QUESTION_NUMBER == "PF_17").QUESTION_TEXT;
        Q4Label.Text = "PFA55 - " + questions.First(q => q.QUESTION_NUMBER == "PFA55").QUESTION_TEXT;
        Q5Label.Text = "PFC45 - " + questions.First(q => q.QUESTION_NUMBER == "PFC45").QUESTION_TEXT;
        Q6Label.Text = "PFC53 - " + questions.First(q => q.QUESTION_NUMBER == "PFC53").QUESTION_TEXT;
        Q7Label.Text = "PFA9 - " + questions.First(q => q.QUESTION_NUMBER == "PFA9").QUESTION_TEXT;
        Q8Label.Text = "PFA20 - " + questions.First(q => q.QUESTION_NUMBER == "PFA20").QUESTION_TEXT;
        Q9Label.Text = "PFA12 - " + questions.First(q => q.QUESTION_NUMBER == "PFA12").QUESTION_TEXT;
        Q10Label.Text = "PF 23 - " + questions.First(q => q.QUESTION_NUMBER == "PF_23").QUESTION_TEXT;
        Q11Label.Text = "PF 53 - " + questions.First(q => q.QUESTION_NUMBER == "PF_53").QUESTION_TEXT;
        lblCopyRight.Text = questions.First(q => q.QUESTION_NUMBER == "CopyRight").QUESTION_TEXT;
        lblPF1.Text = questions.First(q => q.QUESTION_NUMBER == "Support").QUESTION_TEXT;
    }

    private string GetInstrumentTitle(int surveyID)
    {
        string ret = String.Empty;

        try
        {
            List<string> instrumentTitle = selectedInstrumentType.Title;
            if (instrumentTitle.Count > 0)
            {
                foreach (string titleLine in instrumentTitle)
                {
                    if (titleLine.Contains("PhD"))
                    {
                        ret = ret + "<small>" + titleLine + "</small>" + "<br \\>";
                    }
                    else
                    {
                        ret = ret + titleLine + "<br \\>";
                    }
                }
            }

        }
        catch (Exception ex)
        {
            Exception _tbilogerror = HandleTBIException(ex, "PhysicalFunctionwMobilityAid.aspx", "100027", "GetInstrumentTitle()");
            // Ignore error
        }

        return ret;
    }
}

    #endregion Private Methods